<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Favorite extends Model 
{

    protected $table = 'favorites';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('author_id', 'profile_id');

    public function profile()
    {
        return $this->belongsTo('App\Models\Profile', 'profile_id');
    }

}